/*
Half-Life MAP viewing utility.
Copyright (C) 2003  Ryan Samuel Gregg

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#pragma once

#using <System.Drawing.dll>
#using <System.Windows.Forms.dll>

using namespace System::ComponentModel;
using namespace System::Drawing;
using namespace System::Windows::Forms;
using namespace System::IO;

#include "Types.h"
#include "Engine.h"
#include "MAPLoader.h"
#include "PTSLoader.h"
#include "TextureManager.h"
#include "WorldObject.h"
#include "World.h"
#include "Entity.h"
#include "Brush.h"
#include "Face.h"
#include "ArgVal.h"
#include "PointFile.h"

#include "AboutForm.h"

namespace WorldObjectType
{
	enum WorldObjectType { Entity, Brush, Face };
}

__abstract __gc class CWorldObjectTreeNode : public TreeNode
{
private:
	CWorldObject *WorldObject;
	WorldObjectType::WorldObjectType eWorldObjectType;

public:
	CWorldObjectTreeNode(String *Name, CWorldObject *WorldObject, WorldObjectType::WorldObjectType eWorldObjectType)
	{
		this->Text = Name;
		this->WorldObject = WorldObject;
		this->eWorldObjectType = eWorldObjectType;
	}

	CWorldObject *Selected()
	{
		return WorldObject;
	}

	WorldObjectType::WorldObjectType GetType()
	{
		return eWorldObjectType;
	}
};

__gc class CEntityTreeNode : public CWorldObjectTreeNode
{
public:
	CEntityTreeNode(String *Name, CWorldObject *WorldObject) : CWorldObjectTreeNode(Name, WorldObject, WorldObjectType::Entity)
	{
		
	}
};

__gc class CBrushTreeNode : public CWorldObjectTreeNode
{
public:
	CBrushTreeNode(String *Name, CWorldObject *WorldObject) : CWorldObjectTreeNode(Name, WorldObject, WorldObjectType::Brush)
	{
		
	}
};

__gc class CFaceTreeNode : public CWorldObjectTreeNode
{
public:
	CFaceTreeNode(String *Name, CWorldObject *WorldObject) : CWorldObjectTreeNode(Name, WorldObject, WorldObjectType::Face)
	{
		 
	}
};

__gc class CMainForm : public Form
{
private:
	bool bCloseing;
	String *sStartupMAP;

	ArrayList *RecentFiles;

	CEngine *Engine;
	CMAPLoader *MAPLoader;
	CPTSLoader *PTSLoader;
	CConfig *Config;

	CAboutForm *AboutForm;

	::MainMenu *mnuMainMenu;

	::MenuItem *cmdFile;
	::MenuItem *cmdOpen;
	::MenuItem *cmdFileSep1;
	::MenuItem *cmdRecentFiles;
	::MenuItem *cmdFileSep2;
	::MenuItem *cmdExit;

	::MenuItem *cmdView;
	::MenuItem *cmdTextured;
	::MenuItem *cmdSolid;
	::MenuItem *cmdWireFrame;
	::MenuItem *cmdPoints;
	::MenuItem *cmdViewSep1;
	::MenuItem *cmdDrawSpecialTextures;
	::MenuItem *cmdDrawSelection;
	::MenuItem *cmdDrawPointFile;
	::MenuItem *cmdViewSep2;
	::MenuItem *cmdOutlineScene;
	::MenuItem *cmdLightScene;
	::MenuItem *cmdViewSep3;
	::MenuItem *cmdFog;
	::MenuItem *cmdViewSep4;
	::MenuItem *cmdTextureFilter;
	::MenuItem *cmdNonMipmapped;
	::MenuItem *cmdMipmapped;
	::MenuItem *cmdNearest;
	::MenuItem *cmdLinear;
	::MenuItem *cmdMipNearest;
	::MenuItem *cmdMipLinear;
	::MenuItem *cmdMipBilinear;
	::MenuItem *cmdMipTrilinear;
	::MenuItem *cmdMipIsotropic;
	::MenuItem *cmdMipAnisotropic;

	::MenuItem *cmdPointFile;
	::MenuItem *cmdLoadPointFile;
	::MenuItem *cmdUnloadPointFile;

	::MenuItem *cmdHelp;
	::MenuItem *cmdAbout;

	::OpenFileDialog *dlgOpenMAPFile;
	::OpenFileDialog *dlgOpenPTSFile;

	::StatusBar *barStatusMain;

	::Panel *pnlSide;
	::Panel *pnlMain;
	::Panel *pnlBottom;

	::TreeView *treWorld;
	::Splitter *splProperties;
	::ListView *lstProperties;

	::Splitter *splTree;

	::PictureBox *pic3D;

	::Splitter *splConsole;

	::CRichTextBox *txtConsole;

public:
	CMainForm(String *sStartupMAP, CConfig *Config);

private:
	void LoadWorld(String *sFileName);
	void LoadPointFile(String *sFileName);
	void UnloadPointFile();
	void BuildTree(CWorld *World);

	void AddRecentFile(String *sFile);
	void UpdateRecentFiles();

	void Exit();
	
	void CMainForm_Load(::Object *sender, ::EventArgs *e);
	void CMainForm_Closeing(::Object *sender, ::CancelEventArgs *e);

	void pic3D_Resize(::Object *sender, ::EventArgs *e);
	void pic3D_Paint(::Object *sender, ::PaintEventArgs *e);
	void pic3D_MouseMove(::Object *sender, ::MouseEventArgs *e);
	void pic3D_MouseDown(::Object *sender, ::MouseEventArgs *e);
	void pic3D_MouseUp(::Object *sender, ::MouseEventArgs *e);
	void pic3D_KeyDown(::Object *sender, ::KeyEventArgs *e);
	void pic3D_KeyUp(::Object *sender, ::KeyEventArgs *e);

	void treWorld_AfterSelect(::Object *sender, ::TreeViewEventArgs *e);
	void lstProperties_Resize(::Object *sender, ::EventArgs *e);

	void cmdOpen_Click(::Object *sender, ::EventArgs *e);
	void cmdRecentFile_Click(::Object *sender, ::EventArgs *e);
	void cmdExit_Click(::Object *sender, ::EventArgs *e);

	void cmdTextured_Click(::Object *sender, ::EventArgs *e);
	void cmdSolid_Click(::Object *sender, ::EventArgs *e);
	void cmdWireFrame_Click(::Object *sender, ::EventArgs *e);
	void cmdPoints_Click(::Object *sender, ::EventArgs *e);
	void cmdDrawSpecialTextures_Click(::Object *sender, ::EventArgs *e);
	void cmdDrawSelection_Click(::Object *sender, ::EventArgs *e);
	void cmdDrawPointFile_Click(::Object *sender, ::EventArgs *e);
	void cmdOutlineScene_Click(::Object *sender, ::EventArgs *e);
	void cmdLightScene_Click(::Object *sender, ::EventArgs *e);
	void cmdFog_Click(::Object *sender, ::EventArgs *e);

	void cmdNearest_Click(::Object *sender, ::EventArgs *e);
	void cmdLinear_Click(::Object *sender, ::EventArgs *e);
	void cmdMipNearest_Click(::Object *sender, ::EventArgs *e);
	void cmdMipLinear_Click(::Object *sender, ::EventArgs *e);
	void cmdMipBilinear_Click(::Object *sender, ::EventArgs *e);
	void cmdMipTrilinear_Click(::Object *sender, ::EventArgs *e);
	void cmdMipIsotropic_Click(::Object *sender, ::EventArgs *e);
	void cmdMipAnisotropic_Click(::Object *sender, ::EventArgs *e);

	void cmdLoadPointFile_Click(::Object *sender, ::EventArgs *e);
	void cmdUnloadPointFile_Click(::Object *sender, ::EventArgs *e);

	void cmdAbout_Click(::Object *sender, ::EventArgs *e);

	void GetHalfLifePath();
	bool WriteConfigFile(String *sFile);
	bool LoadConfigFile(String *sFile);
	bool ProcessLine(String *sLine, String **sArg, String **sVal);
};